# eNeed.shop (PHP + MySQL)

## 1) Requirements
- Nginx + PHP-FPM (PHP 8.x recommended)
- MySQL/MariaDB

## 2) Install on VPS (Nginx)
1. Upload this project to: `/var/www/eneed_shop`
2. Import DB:
   - Create database `eneed_shop`
   - Import `sql/schema.sql`
3. Edit DB credentials in: `includes/config.php`

### Nginx (suggested)
Set **document root** to the `public` folder:

```
server {
  ...
  root /var/www/eneed_shop/public;
  index index.php;

  location / {
    try_files $uri $uri/ /index.php?$query_string;
  }

  location ~ \.php$ {
    include snippets/fastcgi-php.conf;
    fastcgi_pass unix:/run/php/php8.2-fpm.sock; # adjust
  }

  client_max_body_size 20M;
}
```

## 3) Admin Login
- URL: `/admin/login.php`
- Default: **admin / admin123** (change later)

## 4) Key Features
- Categories/Subcategories/Brands (MySQL)
- Products with **multiple images** upload
- Slider banner upload
- Orders (pending/processing/complete/cancel)
- Invoice print with shop logo + QR (invoice link)
- Settings: shop name/logo/phone/address/shipping + optional WhatsApp API

## 5) Cache Busting (no old JS/CSS)
All assets are loaded as `?v=filemtime` via `asset()` helper. So reload always gets latest.
