<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/util.php';
require_admin();
$title = $title ?? 'Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title><?=e($title)?> | eNeed Admin</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="<?=e(asset('assets/css/admin.css'))?>">
</head>
<body class="bg-slate-50">
<div class="min-h-screen flex">
  <aside class="w-64 hidden md:block bg-white border-r">
    <div class="p-4 border-b">
      <div class="text-lg font-black">eNeed Admin</div>
      <div class="text-xs text-slate-500 font-bold mt-1"><?=e($_SESSION['admin_username'] ?? '')?></div>
    </div>
    <nav class="p-3 text-sm font-bold text-slate-700 space-y-1">
      <a class="navlink" href="/admin/dashboard.php">Dashboard</a>
      <a class="navlink" href="/admin/categories.php">Categories</a>
      <a class="navlink" href="/admin/subcategories.php">Subcategories</a>
      <a class="navlink" href="/admin/brands.php">Brands</a>
      <a class="navlink" href="/admin/products.php">Products</a>
      <a class="navlink" href="/admin/sliders.php">Sliders</a>
      <a class="navlink" href="/admin/orders.php">Orders</a>
      <a class="navlink" href="/admin/settings.php">Settings</a>
      <a class="navlink" href="/admin/logout.php">Logout</a>
    </nav>
  </aside>
  <main class="flex-1">
    <header class="sticky top-0 bg-white border-b p-4 flex items-center justify-between">
      <div class="text-xl font-black"><?=e($title)?></div>
      <div class="md:hidden flex gap-2">
        <a class="px-3 py-2 border rounded-xl font-black text-xs" href="/admin/dashboard.php">Home</a>
        <a class="px-3 py-2 border rounded-xl font-black text-xs" href="/admin/logout.php">Logout</a>
      </div>
    </header>
    <div class="p-4">
