<?php
$title = 'Brands';
require_once __DIR__ . '/_layout_top.php';
$msg=''; $err='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  $action=$_POST['action']??'';
  if($action==='create'){
    $name=trim($_POST['name']??'');
    if($name==='') $err='Name required';
    else {
      $slug=slugify($name);
      try{ q('INSERT INTO brands(name,slug) VALUES(?,?)',[$name,$slug]); $msg='Added'; }
      catch(Exception $e){ $err='Brand already exists'; }
    }
  }
  if($action==='delete'){
    $id=(int)($_POST['id']??0);
    q('DELETE FROM brands WHERE id=?',[$id]);
    $msg='Deleted';
  }
}

$rows=q('SELECT id,name,slug FROM brands ORDER BY id DESC')->fetchAll();
?>

<?php if($msg): ?><div class="card p-3 mb-3 text-green-700 font-bold"><?=e($msg)?></div><?php endif; ?>
<?php if($err): ?><div class="card p-3 mb-3 text-red-700 font-bold"><?=e($err)?></div><?php endif; ?>

<div class="card p-4">
  <form method="post" class="flex flex-col md:flex-row gap-2 items-end">
    <input type="hidden" name="action" value="create">
    <div class="flex-1">
      <div class="text-xs font-black text-slate-500 mb-1">Brand name</div>
      <input name="name" class="w-full border rounded-xl px-4 py-3 font-bold" placeholder="e.g. Samsung" required>
    </div>
    <button class="btn btn-primary">Add</button>
  </form>
</div>

<div class="card p-4 mt-4">
  <div class="text-sm font-black mb-3">All Brands</div>
  <div class="overflow-x-auto">
    <table class="table">
      <thead><tr><th>Name</th><th>Slug</th><th>Action</th></tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?=e($r['name'])?></td>
            <td class="text-slate-500 text-xs font-bold"><?=e($r['slug'])?></td>
            <td>
              <form method="post" onsubmit="return confirm('Delete brand?')" style="display:inline">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?=e($r['id'])?>">
                <button class="btn">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/_layout_bottom.php';
