<?php
$title = 'Categories';
require_once __DIR__ . '/_layout_top.php';

$msg = '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';
  if ($action === 'create') {
    $name = trim($_POST['name'] ?? '');
    if ($name==='') $err='Name required';
    else {
      $slug = slugify($name);
      try{
        q('INSERT INTO categories(name, slug) VALUES(?,?)', [$name,$slug]);
        $msg = 'Category created';
      }catch(Exception $e){ $err='Category already exists'; }
    }
  } elseif($action==='delete') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id>0) {
      $has = (int)q('SELECT COUNT(*) c FROM subcategories WHERE category_id=?', [$id])->fetch()['c'];
      if ($has>0) {
        $err = 'Cannot delete: subcategories exist. Delete subcategories first.';
      } else {
        q('DELETE FROM categories WHERE id=?', [$id]);
        $msg = 'Category deleted';
      }
    }
  }
}

$rows = q('SELECT c.*, (SELECT COUNT(*) FROM subcategories s WHERE s.category_id=c.id) AS sub_count FROM categories c ORDER BY c.id DESC')->fetchAll();
?>

<div class="grid md:grid-cols-3 gap-4">
  <div class="card p-4">
    <div class="font-black">Add Category</div>
    <form method="post" class="mt-3 space-y-2">
      <input type="hidden" name="action" value="create" />
      <input name="name" class="w-full border rounded-xl px-3 py-2 font-bold" placeholder="Category name" required />
      <button class="btn btn-primary w-full" type="submit">Save</button>
    </form>
    <?php if($msg): ?><div class="mt-3 p-3 rounded-xl bg-green-50 border text-green-700 text-sm font-bold"><?=e($msg)?></div><?php endif; ?>
    <?php if($err): ?><div class="mt-3 p-3 rounded-xl bg-red-50 border text-red-700 text-sm font-bold"><?=e($err)?></div><?php endif; ?>
  </div>

  <div class="card p-4 md:col-span-2">
    <div class="font-black">All Categories</div>
    <div class="overflow-auto mt-3">
      <table class="table">
        <thead><tr><th>Name</th><th>Subcategories</th><th>Action</th></tr></thead>
        <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td class="font-bold"><?=e($r['name'])?></td>
            <td><?= (int)$r['sub_count'] ?></td>
            <td>
              <form method="post" onsubmit="return confirm('Delete this category?')" style="display:inline">
                <input type="hidden" name="action" value="delete" />
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>" />
                <button class="btn" type="submit" <?= ((int)$r['sub_count']>0)?'disabled title="Delete subcategories first"':''; ?>>Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
    <div class="text-xs text-slate-500 font-bold mt-2">Category ID auto (MySQL). IDs are hidden in UI.</div>
  </div>
</div>

<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
