<?php
$title = 'Dashboard';
require_once __DIR__ . '/_layout_top.php';

$counts = [
  'products' => (int)q('SELECT COUNT(*) c FROM products')->fetch()['c'],
  'orders_pending' => (int)q("SELECT COUNT(*) c FROM orders WHERE status='pending'")->fetch()['c'],
  'orders_processing' => (int)q("SELECT COUNT(*) c FROM orders WHERE status='processing'")->fetch()['c'],
  'orders_complete' => (int)q("SELECT COUNT(*) c FROM orders WHERE status='complete'")->fetch()['c'],
];
$today = q("SELECT COALESCE(SUM(total),0) sum FROM orders WHERE status<>'cancel' AND DATE(created_at)=CURDATE()...")->fetch();
$todayRev = (float)$today['sum'];
?>

<div class="grid grid-cols-2 md:grid-cols-4 gap-3">
  <div class="card p-4">
    <div class="text-xs font-black text-slate-500">Products</div>
    <div class="text-2xl font-black mt-1"><?=e((string)$counts['products'])?></div>
  </div>
  <div class="card p-4">
    <div class="text-xs font-black text-slate-500">Pending</div>
    <div class="text-2xl font-black mt-1"><?=e((string)$counts['orders_pending'])?></div>
  </div>
  <div class="card p-4">
    <div class="text-xs font-black text-slate-500">Processing</div>
    <div class="text-2xl font-black mt-1"><?=e((string)$counts['orders_processing'])?></div>
  </div>
  <div class="card p-4">
    <div class="text-xs font-black text-slate-500">Complete</div>
    <div class="text-2xl font-black mt-1"><?=e((string)$counts['orders_complete'])?></div>
  </div>
</div>

<div class="grid grid-cols-1 md:grid-cols-3 gap-3 mt-3">
  <div class="card p-4 md:col-span-1">
    <div class="text-xs font-black text-slate-500">Today Revenue</div>
    <div class="text-2xl font-black mt-1">৳ <?=e(number_format($todayRev,2))?></div>
    <div class="text-xs text-slate-500 font-bold mt-2">(Cancel excluded)</div>
  </div>
  <div class="card p-4 md:col-span-2">
    <div class="text-xs font-black text-slate-500">Quick Tips</div>
    <ul class="list-disc pl-5 text-sm font-bold text-slate-700 mt-2 space-y-1">
      <li>Categories cannot be deleted if they have subcategories (delete subs first).</li>
      <li>Product link: <span class="font-black">/product.php?id=PUBLIC_ID</span></li>
      <li>Invoice: Orders → Invoice button</li>
    </ul>
  </div>
</div>

<?php require_once __DIR__ . '/_layout_bottom.php';
