<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/util.php';
require_admin();

$code = $_GET['code'] ?? '';
if(!$code){ http_response_code(400); echo 'Missing code'; exit; }

$order = q('SELECT * FROM orders WHERE order_code=? LIMIT 1',[$code])->fetch();
if(!$order){ http_response_code(404); echo 'Order not found'; exit; }

$items = q('SELECT * FROM order_items WHERE order_id=? ORDER BY id ASC',[(int)$order['id']])->fetchAll();
$st = q('SELECT * FROM site_settings WHERE id=1')->fetch() ?: [];

$invoiceUrl = base_url() . '/admin/invoice.php?code=' . urlencode($code);
$qr = 'https://api.qrserver.com/v1/create-qr-code/?size=180x180&data=' . urlencode($invoiceUrl);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Invoice <?=e($code)?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    @media print{ .no-print{display:none} body{background:#fff} }
  </style>
</head>
<body class="bg-slate-100 p-4">
  <div class="max-w-2xl mx-auto bg-white border rounded-2xl p-6">
    <div class="flex items-start justify-between gap-4">
      <div>
        <div class="flex items-center gap-3">
          <?php if(!empty($st['logo_path'])): ?>
            <img src="/<?=e($st['logo_path'])?>" alt="logo" class="w-14 h-14 object-contain rounded-xl border" />
          <?php endif; ?>
          <div>
            <div class="text-2xl font-black"><?=e($st['shop_name'] ?? 'eNeed.shop')?></div>
            <div class="text-xs font-bold text-slate-600 mt-1"><?=e($st['address'] ?? '')?></div>
            <div class="text-xs font-bold text-slate-600"><?=e($st['contact_phone'] ?? '')?></div>
          </div>
        </div>
      </div>
      <div class="text-right">
        <img src="<?=e($qr)?>" alt="QR" class="w-28 h-28 ml-auto" />
        <div class="text-[10px] font-bold text-slate-500 mt-1">Scan to open invoice</div>
      </div>
    </div>

    <div class="mt-6 grid grid-cols-2 gap-3 text-sm">
      <div class="p-3 rounded-xl border bg-slate-50">
        <div class="text-xs font-black text-slate-500">Invoice</div>
        <div class="font-black"><?=e($code)?></div>
        <div class="text-xs text-slate-500 font-bold mt-1"><?=e($order['created_at'])?></div>
      </div>
      <div class="p-3 rounded-xl border bg-slate-50">
        <div class="text-xs font-black text-slate-500">Customer</div>
        <div class="font-black"><?=e($order['customer_name'])?></div>
        <div class="text-xs text-slate-600 font-bold"><?=e($order['customer_phone'])?></div>
        <div class="text-xs text-slate-600 font-bold mt-1"><?=e($order['customer_address'] ?? '')?></div>
      </div>
    </div>

    <div class="mt-6 overflow-x-auto">
      <table class="w-full text-sm">
        <thead>
          <tr class="text-left border-b">
            <th class="py-2">Item</th>
            <th class="py-2">Qty</th>
            <th class="py-2">Price</th>
            <th class="py-2 text-right">Total</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($items as $it): $line = (float)$it['price'] * (int)$it['qty']; ?>
            <tr class="border-b">
              <td class="py-2">
                <div class="font-bold"><?=e($it['product_name'])?></div>
                <?php if(!empty($it['variant'])): ?><div class="text-xs text-slate-500 font-bold"><?=e($it['variant'])?></div><?php endif; ?>
              </td>
              <td class="py-2 font-bold"><?=e((string)$it['qty'])?></td>
              <td class="py-2 font-bold">৳ <?=e(number_format((float)$it['price'],2))?></td>
              <td class="py-2 font-black text-right">৳ <?=e(number_format($line,2))?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <div class="mt-4 flex flex-col items-end gap-1 text-sm">
      <div class="flex w-64 justify-between font-bold"><span>Subtotal</span><span>৳ <?=e(number_format((float)$order['subtotal'],2))?></span></div>
      <div class="flex w-64 justify-between font-bold"><span>Shipping</span><span>৳ <?=e(number_format((float)$order['shipping'],2))?></span></div>
      <div class="flex w-64 justify-between font-black text-lg border-t pt-2 mt-1"><span>Total</span><span>৳ <?=e(number_format((float)$order['total'],2))?></span></div>
    </div>

    <div class="mt-6 flex gap-2 no-print">
      <button onclick="window.print()" class="px-4 py-2 rounded-xl font-black bg-slate-900 text-white">Print / Download</button>
      <a href="/admin/orders.php" class="px-4 py-2 rounded-xl font-black border">Back</a>
    </div>
  </div>
</body>
</html>
