<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/util.php';

start_session();
if (!empty($_SESSION['admin_id'])) { header('Location: /admin/dashboard.php'); exit; }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['username'] ?? '');
  $p = trim($_POST['password'] ?? '');
  if (admin_login($u, $p)) { header('Location: /admin/dashboard.php'); exit; }
  $error = 'Invalid username or password';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Admin Login</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="min-h-screen bg-slate-50 flex items-center justify-center p-4">
  <div class="w-full max-w-md bg-white border rounded-2xl p-6 shadow-sm">
    <div class="text-2xl font-black">eNeed Admin</div>
    <div class="text-sm text-slate-500 font-bold mt-1">Login with your username & password</div>

    <?php if($error): ?>
      <div class="mt-4 p-3 rounded-xl bg-red-50 border border-red-200 text-red-700 text-sm font-bold"><?=e($error)?></div>
    <?php endif; ?>

    <form method="post" class="mt-5 space-y-3">
      <input name="username" class="w-full border rounded-xl px-4 py-3 font-bold" placeholder="Username" required>
      <input type="password" name="password" class="w-full border rounded-xl px-4 py-3 font-bold" placeholder="Password" required>
      <button class="w-full rounded-xl py-3 font-black bg-slate-900 text-white">Login</button>
    </form>

    <div class="text-xs text-slate-500 font-bold mt-4">Default: admin / admin123</div>
  </div>
</body>
</html>
