<?php
$title = 'Orders';
require_once __DIR__ . '/_layout_top.php';

$msg='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $code = $_POST['code'] ?? '';
  $status = $_POST['status'] ?? '';
  if($code && in_array($status,['pending','processing','complete','cancel'],true)){
    q('UPDATE orders SET status=? WHERE order_code=?',[$status,$code]);
    $msg='Status updated';
  }
}

$orders = q('SELECT * FROM orders ORDER BY id DESC LIMIT 200')->fetchAll();
?>
<?php if($msg): ?><div class="card p-3 mb-4 text-green-700 font-bold"><?=e($msg)?></div><?php endif; ?>
<div class="card p-4">
  <div class="tablewrap">
    <table class="table">
      <thead>
        <tr>
          <th>Order</th><th>Customer</th><th>Total</th><th>Status</th><th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($orders as $o): ?>
          <tr>
            <td class="font-black"><?=e($o['order_code'])?><div class="text-xs text-slate-500 font-bold"><?=e($o['created_at'])?></div></td>
            <td><div class="font-bold"><?=e($o['customer_name'])?></div><div class="text-xs text-slate-500 font-bold"><?=e($o['customer_phone'])?></div></td>
            <td class="font-black">৳ <?=number_format((float)$o['total'],2)?></td>
            <td>
              <form method="post" class="flex items-center gap-2">
                <input type="hidden" name="code" value="<?=e($o['order_code'])?>">
                <select name="status" class="border rounded-xl px-3 py-2 font-bold text-xs">
                  <?php foreach(['pending','processing','complete','cancel'] as $s): ?>
                    <option value="<?=e($s)?>" <?=$o['status']===$s?'selected':''?>><?=strtoupper($s)?></option>
                  <?php endforeach; ?>
                </select>
                <button class="btn btn-primary" type="submit">Save</button>
                <a class="btn" href="/admin/invoice.php?code=<?=urlencode($o['order_code'])?>" target="_blank">Invoice</a>
              </form>
            </td>
            <td></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php';
