<?php
$title = 'Products';
require_once __DIR__ . '/_layout_top.php';

$cats = q('SELECT id,name FROM categories ORDER BY name ASC')->fetchAll();
$subs = q('SELECT id,category_id,name FROM subcategories ORDER BY name ASC')->fetchAll();
$brands = q('SELECT id,name FROM brands ORDER BY name ASC')->fetchAll();
$msg=''; $err='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  $action = $_POST['action'] ?? '';
  if($action==='create'){
    $category_id = (int)($_POST['category_id'] ?? 0);
    $subcategory_id = (int)($_POST['subcategory_id'] ?? 0);
    $brand_id = (int)($_POST['brand_id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $purchase_price = (float)($_POST['purchase_price'] ?? 0);
    $old_price = (float)($_POST['old_price'] ?? 0);
    $price = (float)($_POST['price'] ?? 0);
    $stock = (int)($_POST['stock'] ?? 0);
    $colors = trim($_POST['colors'] ?? '');
    $sizes = trim($_POST['sizes'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $is_highlight = !empty($_POST['is_highlight']) ? 1 : 0;

    if(!$category_id || $name==='' || $price<=0){
      $err='Category, name, price required';
    } else {
      $public_id = random_public_id(12);
      // ensure unique
      while(q('SELECT COUNT(*) c FROM products WHERE public_id=?',[$public_id])->fetch()['c']>0){
        $public_id = random_public_id(12);
      }
      $slug = slugify($name.'-'.$public_id);

      $db = db();
      $db->beginTransaction();
      try{
        q('INSERT INTO products(public_id,category_id,subcategory_id,brand_id,name,slug,purchase_price,old_price,price,stock,colors,sizes,description,is_highlight) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)',
          [$public_id,$category_id,$subcategory_id?:null,$brand_id?:null,$name,$slug,$purchase_price,$old_price,$price,$stock,$colors,$sizes,$description,$is_highlight]);
        $pid = (int)$db->lastInsertId();
        $paths = handle_multi_upload('images','products');
        $i=0;
        foreach($paths as $p){
          q('INSERT INTO product_images(product_id,image_path,sort_order) VALUES(?,?,?)',[$pid,$p,$i++]);
        }
        $db->commit();
        $msg='Product added';
      } catch(Exception $e){
        $db->rollBack();
        $err='Failed (duplicate slug?)';
      }
    }
  }
  if($action==='delete'){
    $id = (int)($_POST['id'] ?? 0);
    if($id){
      q('DELETE FROM products WHERE id=?',[$id]);
      $msg='Deleted';
    }
  }
}

$products = q('SELECT p.id,p.public_id,p.name,p.price,p.stock,p.is_highlight,c.name category
              FROM products p JOIN categories c ON c.id=p.category_id
              ORDER BY p.id DESC LIMIT 200')->fetchAll();
$subJson = json_encode(array_map(fn($s)=>['id'=>$s['id'],'category_id'=>$s['category_id'],'name'=>$s['name']], $subs), JSON_UNESCAPED_UNICODE);
?>

<?php if($msg): ?><div class="card p-3 mb-4 border-l-4 border-green-500"><div class="font-bold text-green-700"><?=e($msg)?></div></div><?php endif; ?>
<?php if($err): ?><div class="card p-3 mb-4 border-l-4 border-red-500"><div class="font-bold text-red-700"><?=e($err)?></div></div><?php endif; ?>

<div class="grid md:grid-cols-2 gap-4">
  <div class="card p-4">
    <div class="font-black mb-3">Add Product</div>
    <form method="post" enctype="multipart/form-data" class="space-y-3">
      <input type="hidden" name="action" value="create">
      <div class="grid grid-cols-2 gap-2">
        <select name="category_id" id="catSel" class="w-full border rounded-xl px-3 py-2 font-bold" required>
          <option value="">Select Category</option>
          <?php foreach($cats as $c): ?>
            <option value="<?=e($c['id'])?>"><?=e($c['name'])?></option>
          <?php endforeach; ?>
        </select>
        <select name="subcategory_id" id="subSel" class="w-full border rounded-xl px-3 py-2 font-bold">
          <option value="">Subcategory (optional)</option>
        </select>
      </div>
      <select name="brand_id" class="w-full border rounded-xl px-3 py-2 font-bold">
        <option value="">Brand (optional)</option>
        <?php foreach($brands as $b): ?>
          <option value="<?=e($b['id'])?>"><?=e($b['name'])?></option>
        <?php endforeach; ?>
      </select>

      <input name="name" class="w-full border rounded-xl px-3 py-2 font-bold" placeholder="Product name" required>

      <div class="grid grid-cols-2 gap-2">
        <input name="purchase_price" type="number" step="0.01" class="w-full border rounded-xl px-3 py-2 font-bold" placeholder="Purchase">
        <input name="old_price" type="number" step="0.01" class="w-full border rounded-xl px-3 py-2 font-bold" placeholder="Old price">
      </div>
      <div class="grid grid-cols-2 gap-2">
        <input name="price" type="number" step="0.01" class="w-full border rounded-xl px-3 py-2 font-bold" placeholder="Sale price" required>
        <input name="stock" type="number" class="w-full border rounded-xl px-3 py-2 font-bold" placeholder="Stock">
      </div>

      <div class="grid grid-cols-2 gap-2">
        <input name="colors" class="w-full border rounded-xl px-3 py-2 font-bold" placeholder="Colors (comma)">
        <input name="sizes" class="w-full border rounded-xl px-3 py-2 font-bold" placeholder="Sizes (comma)">
      </div>

      <textarea name="description" class="w-full border rounded-xl px-3 py-2 font-bold" rows="3" placeholder="Description"></textarea>

      <div class="flex items-center gap-2">
        <input id="hl" name="is_highlight" type="checkbox" class="h-4 w-4">
        <label for="hl" class="font-bold">Highlighted</label>
      </div>

      <div>
        <div class="text-xs font-black text-slate-500 mb-1">Images (multiple)</div>
        <input name="images[]" type="file" accept="image/*" multiple class="w-full border rounded-xl px-3 py-2 font-bold">
      </div>

      <button class="btn btn-primary">Save</button>
      <div class="text-xs text-slate-500 font-bold">Product public ID auto generates; link: /?pid=PUBLIC_ID</div>
    </form>
  </div>

  <div class="card p-4">
    <div class="font-black mb-3">Latest Products</div>
    <div class="overflow-auto">
      <table class="table text-sm">
        <thead><tr><th>ID</th><th>Name</th><th>Price</th><th>Stock</th><th></th></tr></thead>
        <tbody>
        <?php foreach($products as $p): ?>
          <tr>
            <td class="font-black"><?=e($p['public_id'])?></td>
            <td><?=e($p['name'])?><div class="text-xs text-slate-500 font-bold"><?=e($p['category'])?></div></td>
            <td class="font-black">৳ <?=e($p['price'])?></td>
            <td><?=e($p['stock'])?></td>
            <td>
              <form method="post" onsubmit="return confirm('Delete?')">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?=e($p['id'])?>">
                <button class="btn">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script>
const subs = <?= $subJson ?>;
const catSel = document.getElementById('catSel');
const subSel = document.getElementById('subSel');
function fillSubs(){
  const cid = catSel.value;
  const list = subs.filter(s=>String(s.category_id)===String(cid));
  subSel.innerHTML = '<option value="">Subcategory (optional)</option>' + list.map(s=>`<option value="${s.id}">${s.name}</option>`).join('');
}
catSel.addEventListener('change', fillSubs);
</script>

<?php require_once __DIR__ . '/_layout_bottom.php';
