<?php
$title = 'Settings';
require_once __DIR__ . '/_layout_top.php';

$st = q('SELECT * FROM site_settings WHERE id=1')->fetch() ?: [];
$msg=''; $err='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  $shop_name = trim($_POST['shop_name'] ?? '');
  $contact_phone = trim($_POST['contact_phone'] ?? '');
  $contact_email = trim($_POST['contact_email'] ?? '');
  $address = trim($_POST['address'] ?? '');
  $shipping_charge = (float)($_POST['shipping_charge'] ?? 0);
  $whatsapp_api_url = trim($_POST['whatsapp_api_url'] ?? '');
  $whatsapp_token = trim($_POST['whatsapp_token'] ?? '');

  $logoPath = $st['logo_path'] ?? '';
  $up = handle_upload('logo','logo');
  if($up) $logoPath = $up;

  q('UPDATE site_settings SET shop_name=?, logo_path=?, contact_phone=?, contact_email=?, address=?, shipping_charge=?, whatsapp_api_url=?, whatsapp_token=? WHERE id=1',
    [$shop_name, $logoPath, $contact_phone, $contact_email, $address, $shipping_charge, $whatsapp_api_url, $whatsapp_token]);
  $msg='Saved';
  $st = q('SELECT * FROM site_settings WHERE id=1')->fetch() ?: [];
}
?>
<div class="card p-5 max-w-3xl">
  <?php if($msg): ?><div class="p-3 rounded-xl bg-green-50 border border-green-200 font-bold text-green-800 mb-4"><?=e($msg)?></div><?php endif; ?>
  <form method="post" enctype="multipart/form-data" class="space-y-4">
    <div>
      <div class="text-xs font-black text-slate-500 mb-1">Shop Name</div>
      <input name="shop_name" value="<?=e($st['shop_name'] ?? '')?>" class="w-full border rounded-xl px-4 py-3 font-bold">
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <div>
        <div class="text-xs font-black text-slate-500 mb-1">Contact Phone</div>
        <input name="contact_phone" value="<?=e($st['contact_phone'] ?? '')?>" class="w-full border rounded-xl px-4 py-3 font-bold">
      </div>
      <div>
        <div class="text-xs font-black text-slate-500 mb-1">Contact Email</div>
        <input name="contact_email" value="<?=e($st['contact_email'] ?? '')?>" class="w-full border rounded-xl px-4 py-3 font-bold">
      </div>
    </div>
    <div>
      <div class="text-xs font-black text-slate-500 mb-1">Address</div>
      <textarea name="address" class="w-full border rounded-xl px-4 py-3 font-bold" rows="3"><?=e($st['address'] ?? '')?></textarea>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <div>
        <div class="text-xs font-black text-slate-500 mb-1">Shipping Charge</div>
        <input type="number" step="0.01" name="shipping_charge" value="<?=e((string)($st['shipping_charge'] ?? 0))?>" class="w-full border rounded-xl px-4 py-3 font-bold">
      </div>
      <div>
        <div class="text-xs font-black text-slate-500 mb-1">Logo (upload)</div>
        <input type="file" name="logo" accept="image/*" class="w-full border rounded-xl px-4 py-3 font-bold">
        <?php if(!empty($st['logo_path'])): ?>
          <img src="/<?=e($st['logo_path'])?>" alt="logo" class="mt-2 h-12">
        <?php endif; ?>
      </div>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <div>
        <div class="text-xs font-black text-slate-500 mb-1">WhatsApp API URL (optional)</div>
        <input name="whatsapp_api_url" value="<?=e($st['whatsapp_api_url'] ?? '')?>" class="w-full border rounded-xl px-4 py-3 font-bold" placeholder="https://...">
      </div>
      <div>
        <div class="text-xs font-black text-slate-500 mb-1">WhatsApp Token (optional)</div>
        <input name="whatsapp_token" value="<?=e($st['whatsapp_token'] ?? '')?>" class="w-full border rounded-xl px-4 py-3 font-bold">
      </div>
    </div>

    <button class="btn btn-primary" type="submit">Save Settings</button>
  </form>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php';
