<?php
$title = 'Sliders';
require_once __DIR__ . '/_layout_top.php';
$msg=''; $err='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  $action=$_POST['action']??'';
  if($action==='create'){
    $titleText = trim($_POST['title']??'');
    $path = handle_upload('image','sliders');
    if(!$path) $err='Upload image (jpg/png/webp)';
    else {
      q('INSERT INTO sliders(title,image_path,is_active,sort_order) VALUES(?,?,1,0)', [$titleText,$path]);
      $msg='Slider added';
    }
  } elseif($action==='delete'){
    $id=(int)($_POST['id']??0);
    if($id) q('DELETE FROM sliders WHERE id=?', [$id]);
    $msg='Deleted';
  }
}

$list = q('SELECT * FROM sliders ORDER BY sort_order ASC, id DESC')->fetchAll();
?>
<div class="card p-4">
  <form method="post" enctype="multipart/form-data" class="grid md:grid-cols-3 gap-3 items-end">
    <input type="hidden" name="action" value="create">
    <div>
      <div class="text-xs font-black text-slate-500">Title</div>
      <input name="title" class="w-full border rounded-xl px-3 py-2 font-bold" placeholder="Optional">
    </div>
    <div>
      <div class="text-xs font-black text-slate-500">Image</div>
      <input type="file" name="image" class="w-full border rounded-xl px-3 py-2 font-bold" required>
    </div>
    <button class="btn btn-primary">Add Slider</button>
  </form>
  <?php if($err): ?><div class="mt-3 p-3 rounded-xl bg-red-50 border border-red-200 text-red-700 text-sm font-bold"><?=e($err)?></div><?php endif; ?>
  <?php if($msg): ?><div class="mt-3 p-3 rounded-xl bg-green-50 border border-green-200 text-green-700 text-sm font-bold"><?=e($msg)?></div><?php endif; ?>
</div>

<div class="card p-4 mt-4">
  <div class="overflow-auto">
  <table class="table">
    <thead><tr class="bg-slate-50"><th>Image</th><th>Title</th><th>Active</th><th></th></tr></thead>
    <tbody>
    <?php foreach($list as $s): ?>
      <tr>
        <td class="p-2"><img src="/<?=e($s['image_path'])?>" class="h-14 w-32 object-cover rounded-xl border"></td>
        <td class="p-2 font-bold"><?=e($s['title'])?></td>
        <td class="p-2"><?= $s['is_active'] ? 'Yes':'No' ?></td>
        <td class="p-2">
          <form method="post" onsubmit="return confirm('Delete slider?')">
            <input type="hidden" name="action" value="delete"><input type="hidden" name="id" value="<?= (int)$s['id']?>">
            <button class="btn">Delete</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php';
