<?php
$title = 'Subcategories';
require_once __DIR__ . '/_layout_top.php';

$cats = q('SELECT id,name FROM categories ORDER BY name ASC')->fetchAll();
$msg=''; $err='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  $action = $_POST['action'] ?? '';
  if($action==='create'){
    $category_id = (int)($_POST['category_id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    if(!$category_id) $err='Select category';
    else if($name==='') $err='Name required';
    else {
      $slug = slugify($name);
      try{ q('INSERT INTO subcategories(category_id,name,slug) VALUES(?,?,?)',[$category_id,$name,$slug]); $msg='Added'; }
      catch(Exception $e){ $err='Already exists'; }
    }
  }
  if($action==='delete'){
    $id=(int)($_POST['id']??0);
    if($id){
      // prevent delete if products exist
      $pc=(int)q('SELECT COUNT(*) c FROM products WHERE subcategory_id=?',[$id])->fetch()['c'];
      if($pc>0) $err='Cannot delete: products exist';
      else { q('DELETE FROM subcategories WHERE id=?',[$id]); $msg='Deleted'; }
    }
  }
}

$list = q('SELECT s.id,s.name,s.slug,c.name as cat_name FROM subcategories s JOIN categories c ON c.id=s.category_id ORDER BY s.id DESC')->fetchAll();

?>
<div class="card p-4">
  <div class="font-black mb-3">Add Subcategory</div>
  <?php if($msg): ?><div class="p-2 mb-2 rounded-xl bg-green-50 border border-green-200 text-green-700 font-bold text-sm"><?=e($msg)?></div><?php endif; ?>
  <?php if($err): ?><div class="p-2 mb-2 rounded-xl bg-red-50 border border-red-200 text-red-700 font-bold text-sm"><?=e($err)?></div><?php endif; ?>

  <form method="post" class="flex flex-col md:flex-row gap-2 items-stretch">
    <input type="hidden" name="action" value="create">
    <select name="category_id" class="border rounded-xl px-3 py-2 font-bold">
      <option value="">Select category</option>
      <?php foreach($cats as $c): ?>
        <option value="<?=e($c['id'])?>"><?=e($c['name'])?></option>
      <?php endforeach; ?>
    </select>
    <input name="name" class="border rounded-xl px-3 py-2 font-bold flex-1" placeholder="Subcategory name" required>
    <button class="btn btn-primary">Add</button>
  </form>
</div>

<div class="card p-4 mt-4">
  <div class="font-black mb-3">All Subcategories</div>
  <table class="table">
    <tr><th>Category</th><th>Name</th><th>Action</th></tr>
    <?php foreach($list as $r): ?>
      <tr>
        <td><?=e($r['cat_name'])?></td>
        <td><?=e($r['name'])?></td>
        <td>
          <form method="post" onsubmit="return confirm('Delete?')">
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="<?=e($r['id'])?>">
            <button class="btn">Delete</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </table>
</div>

<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
