<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/util.php';

$cats = q('SELECT id, name, slug FROM categories ORDER BY id DESC')->fetchAll();
$subs = q('SELECT id, category_id, name, slug FROM subcategories ORDER BY id DESC')->fetchAll();
$brands = q('SELECT id, name, slug FROM brands ORDER BY id DESC')->fetchAll();

json_out([
  'categories' => array_map(fn($c)=>[ 'id' => (string)$c['id'], 'name'=>$c['name'], 'slug'=>$c['slug'] ], $cats),
  'subcategories' => array_map(fn($s)=>[ 'id' => (string)$s['id'], 'categoryId'=>(string)$s['category_id'], 'name'=>$s['name'], 'slug'=>$s['slug'] ], $subs),
  'brands' => array_map(fn($b)=>[ 'id' => (string)$b['id'], 'name'=>$b['name'], 'slug'=>$b['slug'] ], $brands),
]);
