<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/util.php';

$payload = json_decode(file_get_contents('php://input'), true);
if (!is_array($payload)) json_out(['ok'=>false,'error'=>'Invalid JSON'], 400);

$name = trim($payload['name'] ?? '');
$phone = trim($payload['phone'] ?? '');
$address = trim($payload['address'] ?? '');
$items = $payload['items'] ?? [];
if ($name=='' || $phone=='' || !is_array($items) || count($items)<1) {
  json_out(['ok'=>false,'error'=>'Missing fields'], 400);
}

$st = q('SELECT shipping_charge, whatsapp_api_url, whatsapp_token, shop_name FROM site_settings WHERE id=1')->fetch() ?: [];
$shipping = (float)($st['shipping_charge'] ?? 0);

// compute totals
$subtotal = 0.0;
$normItems = [];
foreach($items as $it){
  $pid = trim($it['id'] ?? '');
  $qty = max(1, (int)($it['qty'] ?? 1));
  if($pid==='') continue;
  $prod = q('SELECT id, public_id, name, price FROM products WHERE public_id=? LIMIT 1', [$pid])->fetch();
  if(!$prod) continue;
  $price = (float)$prod['price'];
  $line = $price * $qty;
  $subtotal += $line;
  $normItems[] = [
    'product_id' => (int)$prod['id'],
    'public_id' => $prod['public_id'],
    'name' => $prod['name'],
    'qty' => $qty,
    'price' => $price,
    'variant' => trim($it['variant'] ?? '')
  ];
}
if(!count($normItems)) json_out(['ok'=>false,'error'=>'No valid items'], 400);

$total = $subtotal + $shipping;
$orderCode = 'OD' . date('ymd') . '-' . strtoupper(bin2hex(random_bytes(3)));

$db = db();
$db->beginTransaction();
try{
  q('INSERT INTO orders(order_code, customer_name, customer_phone, customer_address, status, subtotal, shipping, total) VALUES(?,?,?,?,?,?,?,?)',
    [$orderCode, $name, $phone, $address, 'pending', $subtotal, $shipping, $total]);
  $orderId = (int)$db->lastInsertId();
  foreach($normItems as $it){
    q('INSERT INTO order_items(order_id, product_id, product_name, product_public_id, qty, price, variant) VALUES(?,?,?,?,?,?,?)',
      [$orderId, $it['product_id'], $it['name'], $it['public_id'], $it['qty'], $it['price'], $it['variant']]);
  }
  $db->commit();
}catch(Exception $e){
  $db->rollBack();
  json_out(['ok'=>false,'error'=>'DB error'], 500);
}

// Optional WhatsApp notify (your own API)
$apiUrl = trim($st['whatsapp_api_url'] ?? '');
$token = trim($st['whatsapp_token'] ?? '');
if($apiUrl){
  $msg = "New Order: $orderCode\nName: $name\nPhone: $phone\nTotal: $total\n";
  @file_get_contents($apiUrl . (str_contains($apiUrl,'?')?'&':'?') . 'token=' . urlencode($token) . '&message=' . urlencode($msg));
}

json_out(['ok'=>true,'orderCode'=>$orderCode,'invoiceUrl'=> base_url() . '/admin/invoice.php?code=' . urlencode($orderCode)]);
