<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/util.php';

$only = $_GET['only'] ?? 'active';
$where = ($only === 'all') ? '1=1' : 'p.is_active=1';

$rows = q("SELECT p.id, p.public_id, p.name, p.slug, p.price, p.old_price, p.stock,
                 p.colors, p.sizes, p.description, p.is_highlight, p.category_id, p.subcategory_id, p.brand_id,
                 c.name AS category_name, s.name AS subcategory_name, b.name AS brand_name
          FROM products p
          JOIN categories c ON c.id=p.category_id
          LEFT JOIN subcategories s ON s.id=p.subcategory_id
          LEFT JOIN brands b ON b.id=p.brand_id
          WHERE $where
          ORDER BY p.id DESC")->fetchAll();

// images
$ids = array_map(fn($r)=> (int)$r['id'], $rows);
$imgMap = [];
if ($ids) {
  $in = implode(',', array_fill(0, count($ids), '?'));
  $imgs = q("SELECT product_id, image_path FROM product_images WHERE product_id IN ($in) ORDER BY sort_order ASC, id ASC", $ids)->fetchAll();
  foreach ($imgs as $im) {
    $imgMap[(int)$im['product_id']][] = $im['image_path'];
  }
}

$sliders = q('SELECT id, title, image_path, sort_order FROM sliders WHERE is_active=1 ORDER BY sort_order ASC, id DESC')->fetchAll();

json_out([
  'sliderImages' => array_map(fn($s)=>[ 'title'=>$s['title'], 'url'=>$s['image_path'] ], $sliders),
  'products' => array_map(function($r) use ($imgMap){
    $pid = (int)$r['id'];
    $imgs = $imgMap[$pid] ?? [];
    return [
      'id' => $r['public_id'],
      'name' => $r['name'],
      'slug' => $r['slug'],
      'price' => (float)$r['price'],
      'oldPrice' => (float)$r['old_price'],
      'stock' => (int)$r['stock'],
      'colors' => $r['colors'] ?? '',
      'sizes' => $r['sizes'] ?? '',
      'desc' => $r['description'] ?? '',
      'highlight' => (int)$r['is_highlight'],
      'cat' => (string)$r['category_id'],
      'sub' => $r['subcategory_id'] ? (string)$r['subcategory_id'] : '',
      'brand' => $r['brand_id'] ? (string)$r['brand_id'] : '',
      'images' => $imgs,
      'image' => $imgs[0] ?? '',
      'categoryName' => $r['category_name'],
      'subcategoryName' => $r['subcategory_name'] ?? '',
      'brandName' => $r['brand_name'] ?? '',
    ];
  }, $rows)
]);
