<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

function start_session(): void {
  if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
  }
}

function require_admin(): void {
  start_session();
  if (empty($_SESSION['admin_id'])) {
    header('Location: /admin/login.php');
    exit;
  }
}

function admin_login(string $username, string $password): bool {
  start_session();
  $row = q('SELECT id, password_hash FROM admins WHERE username = ? LIMIT 1', [$username])->fetch();
  if (!$row) return false;
  if (!password_verify($password, $row['password_hash'])) return false;
  $_SESSION['admin_id'] = (int)$row['id'];
  $_SESSION['admin_username'] = $username;
  return true;
}

function admin_logout(): void {
  start_session();
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', time()-42000, $p['path'], $p['domain'], $p['secure'], $p['httponly']);
  }
  session_destroy();
}
