<?php
// eNeed.shop config (MySQL)
// 1) Set DB_* values
// 2) Import sql/schema.sql into your database

// Database
const DB_HOST = '127.0.0.1';
const DB_NAME = 'eneed_shop';
const DB_USER = 'root';
const DB_PASS = '';
const DB_CHARSET = 'utf8mb4';

// Base URL (optional). Example: https://eneed.shop
// Leave empty to auto-detect.
const BASE_URL = '';

// Paths
const PROJECT_ROOT = __DIR__ . '/..';
const UPLOADS_PATH = PROJECT_ROOT . '/uploads';

// Session
const SESSION_NAME = 'ENEEDSESS';

// Cache busting (prevent old JS/CSS after reload)
function asset(string $path): string {
  $full = PROJECT_ROOT . '/' . ltrim($path, '/');
  $v = file_exists($full) ? filemtime($full) : time();
  return base_url() . '/' . ltrim($path, '/') . '?v=' . $v;
}

function base_url(): string {
  if (BASE_URL) return rtrim(BASE_URL, '/');
  $https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  return $https . '://' . $host;
}
