<?php
require_once __DIR__ . '/config.php';

function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function slugify(string $text): string {
  $text = strtolower(trim($text));
  $text = preg_replace('/[^a-z0-9\p{Bengali}]+/u', '-', $text);
  $text = trim($text, '-');
  return $text ?: ('item-' . time());
}

function random_public_id(int $len = 12): string {
  $chars = 'ABCDEFGHJKMNPQRSTUVWXYZ23456789';
  $out = '';
  for ($i=0; $i<$len; $i++) {
    $out .= $chars[random_int(0, strlen($chars)-1)];
  }
  return $out;
}

function json_out($data, int $code = 200): void {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
  echo json_encode($data, JSON_UNESCAPED_UNICODE);
  exit;
}

function ensure_dir(string $path): void {
  if (!is_dir($path)) mkdir($path, 0775, true);
}

function handle_upload(string $field, string $subdir, array $allowed = ['jpg','jpeg','png','webp']): ?string {
  if (empty($_FILES[$field]) || $_FILES[$field]['error'] !== UPLOAD_ERR_OK) return null;

  $tmp = $_FILES[$field]['tmp_name'];
  $name = $_FILES[$field]['name'] ?? 'file';
  $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  if (!in_array($ext, $allowed, true)) return null;

  $destDir = UPLOADS_PATH . '/' . trim($subdir,'/');
  ensure_dir($destDir);
  $fname = date('YmdHis') . '-' . bin2hex(random_bytes(4)) . '.' . $ext;
  $dest = $destDir . '/' . $fname;
  if (!move_uploaded_file($tmp, $dest)) return null;
  return 'uploads/' . trim($subdir,'/') . '/' . $fname;
}

function handle_multi_upload(string $field, string $subdir, array $allowed = ['jpg','jpeg','png','webp']): array {
  $paths = [];
  if (empty($_FILES[$field]) || !is_array($_FILES[$field]['name'])) return $paths;

  $count = count($_FILES[$field]['name']);
  for ($i=0; $i<$count; $i++) {
    if ($_FILES[$field]['error'][$i] !== UPLOAD_ERR_OK) continue;
    $name = $_FILES[$field]['name'][$i] ?? 'file';
    $tmp = $_FILES[$field]['tmp_name'][$i];
    $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
    if (!in_array($ext, $allowed, true)) continue;

    $destDir = UPLOADS_PATH . '/' . trim($subdir,'/');
    ensure_dir($destDir);
    $fname = date('YmdHis') . '-' . bin2hex(random_bytes(4)) . '-' . $i . '.' . $ext;
    $dest = $destDir . '/' . $fname;
    if (move_uploaded_file($tmp, $dest)) {
      $paths[] = 'uploads/' . trim($subdir,'/') . '/' . $fname;
    }
  }
  return $paths;
}
