<?php
require_once __DIR__ . '/../includes/config.php';
?><!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>eNeed.shop</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="<?=e(asset('assets/css/styles.css'))?>">
  <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Expires" content="0">
</head>
<body class="bg-slate-50">
<header class="bg-white border-b sticky top-0 z-50">
  <div class="max-w-6xl mx-auto px-4 py-4 flex items-center gap-4">
    <a href="/" class="flex items-center gap-2 font-black text-2xl">
      <img id="siteLogo" src="" alt="logo" class="h-10 w-10 rounded-xl border bg-white object-contain hidden" />
      <span id="siteNameText">eNeed.shop</span>
    </a>
    <div class="flex-1 hidden md:block">
      <input id="mainSearch" autocomplete="off" class="w-full border rounded-xl px-4 py-2 font-bold" placeholder="Search products...">
    </div>
    <button id="cartBtn" class="px-3 py-2 border rounded-xl font-black text-sm">Cart (<span id="cartCount">0</span>)</button>
  </div>
  <div class="max-w-6xl mx-auto px-4 pb-3 hidden md:flex items-center gap-6 text-sm font-black text-slate-600">
    <a href="#" data-home class="hover:text-blue-600">Home</a>
    <div class="relative group">
      <button class="hover:text-blue-600">Categories ▾</button>
      <div id="navCatDropdown" class="absolute hidden group-hover:block bg-white shadow-xl border w-60 py-2 mt-2 rounded-xl"></div>
    </div>
    <a href="#" data-page="about" class="hover:text-blue-600">About</a>
    <a href="#" data-page="contact" class="hover:text-blue-600">Contact</a>
  </div>
</header>

<main class="max-w-6xl mx-auto px-4">
  <div id="catMenuTop" class="catmenu-row"></div>
  <div id="subMenuTop" class="catmenu-row sub"></div>

  <section class="mt-4">
    <div id="heroSliderWrap" class="rounded-2xl overflow-hidden border bg-white"></div>
  </section>

  <div class="mt-6">
    <div id="catMenuBottom" class="catmenu-row"></div>
    <div id="subMenuBottom" class="catmenu-row sub"></div>
  </div>

  <h2 class="mt-8 mb-4 text-xl font-black">Products</h2>
  <div id="productGrid" class="grid grid-cols-2 md:grid-cols-5 gap-3"></div>
</main>

<!-- Cart Drawer -->
<div id="cartDrawer" class="fixed inset-0 hidden z-[80]">
  <div id="cartBackdrop" class="absolute inset-0 bg-black/40"></div>
  <div class="absolute right-0 top-0 bottom-0 w-full max-w-md bg-white p-4">
    <div class="flex items-center justify-between">
      <div class="font-black text-lg">Your Cart</div>
      <button id="cartClose" class="px-3 py-2 border rounded-xl font-black text-xs">Close</button>
    </div>
    <div id="cartItems" class="mt-4 space-y-2"></div>
    <div class="mt-4 border-t pt-3 flex justify-between font-black"><span>Total</span><span>৳ <span id="cartTotal">0</span></span></div>

    <div class="mt-4 space-y-2">
      <input id="cName" class="w-full border rounded-xl px-4 py-3 font-bold" placeholder="Full Name">
      <input id="cPhone" type="tel" autocomplete="off" class="w-full border rounded-xl px-4 py-3 font-bold" placeholder="Mobile Number">
      <textarea id="cAddress" class="w-full border rounded-xl px-4 py-3 font-bold h-24" placeholder="Full Address"></textarea>
      <button id="confirmOrderBtn" class="w-full py-3 rounded-xl bg-green-600 text-white font-black">Confirm Order</button>
      <div id="orderMsg" class="text-sm font-bold text-slate-600"></div>
    </div>
  </div>
</div>

<script src="<?=e(asset('assets/js/app.js'))?>" defer></script>
</body>
</html>
